/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.interaction.InventoryTickModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ArmorClusteringModifier
extends Modifier
implements InventoryTickModifierHook,
AttributesModifierHook {
    private final ResourceLocation KEY = new ResourceLocation("tinkerscalibration", "clustering_armor");

    public boolean isArmor(EquipmentSlot slot) {
        return slot == EquipmentSlot.HEAD || slot == EquipmentSlot.CHEST || slot == EquipmentSlot.LEGS || slot == EquipmentSlot.FEET;
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.ATTRIBUTES, ModifierHooks.INVENTORY_TICK);
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        if (this.isArmor(slot)) {
            float percent = tool.getPersistentData().getFloat(this.KEY);
            if ((double)percent > 0.45) {
                consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("7000a1df-3fe9-4867-9442-8e255d4be96f"), Attributes.f_22284_.m_22087_(), ((double)percent - 0.45) * (double)0.4f, AttributeModifier.Operation.MULTIPLY_BASE));
            } else {
                consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("030355b4-24e5-4d82-b5c4-bf0c7770f84e"), Attributes.f_22285_.m_22087_(), (0.45 - (double)percent) * (double)0.4f, AttributeModifier.Operation.MULTIPLY_BASE));
            }
        }
    }

    public void onInventoryTick(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull Level world, @Nonnull LivingEntity holder, int itemSlot, boolean isSelected, boolean isCorrectSlot, ItemStack stack) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (!world.f_46443_) {
            persistentData.putFloat(this.KEY, this.getPercentage(((Player)holder).m_150109_()));
        }
    }

    public float getPercentage(Inventory i) {
        int sizeInv = i.m_6643_();
        float current = 0.0f;
        float sum = 0.0f;
        while (sizeInv-- > 0) {
            ItemStack stackInv = i.m_8020_(sizeInv);
            if (stackInv.m_41619_() || !stackInv.m_204117_(TinkerTags.Items.MODIFIABLE)) continue;
            ToolStack toolInv = ToolStack.from((ItemStack)stackInv);
            current += (float)toolInv.getCurrentDurability();
            sum += ((Float)toolInv.getStats().get((IToolStat)ToolStats.DURABILITY)).floatValue();
        }
        return current / sum;
    }
}

